clear all;close all;clc
[X1,f1]=audioread('danger_left.wav');
[X2,f2]=audioread('danger_right.wav');
[X3,f3]=audioread('go_left.wav');
[X4,f4]=audioread('go_right.wav');
[X5,f5]=audioread('beep.wav');
X1(X1==0)=NaN;
X2(X2==0)=NaN;
X3(X3==0)=NaN;
X4(X4==0)=NaN;
X5(X5==0)=NaN;
time1=1/f1:1/f1:length(X1)/f1;
time2=1/f2:1/f2:length(X2)/f2;
time3=1/f3:1/f3:length(X3)/f3;
time4=1/f4:1/f4:length(X4)/f4;
time5=1/f5:1/f5:length(X5)/f5;

figure;
    C = [0 0 1
        1 0 0];
    colororder(C);

subplot(2,3,1)
plot(time1,X1)
title('Danger Left')
xlabel('Time (s)');ylabel('Amplitude')
set(gca,'xlim',[0 1])
grid on

subplot(2,3,2)
plot(time2,X2)
title('Danger Right')
xlabel('Time (s)');ylabel('Amplitude')
set(gca,'xlim',[0 1])
grid on

subplot(2,3,4)
plot(time3,X3)
title('Go Left')
xlabel('Time (s)');ylabel('Amplitude')
set(gca,'xlim',[0 1])
grid on

subplot(2,3,5)
plot(time4,X4)
title('Go Right')
xlabel('Time (s)');ylabel('Amplitude')
set(gca,'xlim',[0 1])
grid on

time=1/f5:1/f5:length(X5)/f5;
subplot(2,3,3)
plot(time5,X5(:,1),'-');hold on
plot(time5,X5(:,2),':')

title('Baseline (Beeps)')
xlabel('Time (s)');ylabel('Amplitude')
set(gca,'xlim',[0 1])
grid on

h=findobj('FontName','Helvetica');                                % Obtain plot font object
set(h,'FontSize',14);                                             % Increase font size
